clear all

cd "REMOVED" 

import delimited "data_for_macropru_analysis.csv", varnames(1) numericcols(3 4 to 148)

*** set panel dimension and time dimension (qtr variable is in quarterly format)
/*
gen period = date
gen bank = id
drop date id
*/

gen date = date(period, "YMD")
format date %td

encode bank, gen(institution)

gen qtr = qofd(date)
format qtr %tq
sum qtr
xtset institution qtr 
drop date


*Defining LHS variables
****************************************************
* THESE STILL HAVE THE "l_" NOTATION (SO THAT THE REGRESSION CODE STILL WORKS) BUT
* ARE NO LONGER IN LOGS. 
gen l_OO = appr_occ_tot
gen l_inv = appr_inv_tot
gen tot_loans_no_log = appr_occ_tot + appr_inv_tot
gen l_loans = tot_loans_no_log
gen l_InvIO = appr_inv_io
gen l_OOIO = appr_occ_io
gen tot_IO_no_log = appr_occ_io + appr_inv_io
gen l_TotalIO = tot_IO_no_log
gen l_TotalPI = tot_loans_no_log - tot_IO_no_log
gen l_OOPI = appr_occ_tot - appr_occ_io
gen l_InvPI = appr_inv_tot - appr_inv_io

*** generate the quarterly growth rate. These will be the LHS variables
foreach x in l_OO l_inv l_loans l_InvIO l_OOIO l_TotalIO l_TotalPI l_OOPI l_InvPI {
	gen d`x' = (`x'[_n]/`x'[_n-1]) - 1
	*Cap the growth rate at 300%. Without this CTI IO approvals jump 3900% in June 2013.
	replace d`x' = 3 if d`x' > 3 & d`x' != .
}

gen dif_gr_inv_occ = dl_inv - dl_OO
gen dif_gr_io_pi = dl_TotalIO - dl_TotalPI

* All 'spread' means spread to cash rate
gen spread_oopi = oopi_rate - cr_qe
gen spread_invpi = invpi_rate - cr_qe
gen spread_invio = invio_rate_no_replacement - cr_qe
gen spread_ooio = ooio_rate_no_replacement - cr_qe
gen spread_invio_rep = invio_rate_with_replacement - cr_qe
gen spread_ooio_rep = ooio_rate_with_replacement - cr_qe
* All 'diff' means difference from appropriate control rate
gen diff_spread_invpi = spread_invpi - spread_oopi
gen diff_spread_invio = spread_invio_rep - spread_invpi
*Include first differences
foreach x in spread_oopi spread_invpi spread_invio spread_ooio spread_invio_rep spread_ooio_rep ///
			 diff_spread_invpi diff_spread_invio {
	gen d_`x' = `x'[_n]-`x'[_n-1]
}

*** Approvals by LVR bucket
gen ap_inv_lowlvr = appr_inv_tot - appr_inv_lvrabove80
gen ap_inv_midlvr = appr_inv_lvrabove80 - appr_inv_lvrabove90
gen ap_inv_hghlvr = appr_inv_lvrabove90
gen ap_occ_lowlvr = appr_occ_tot - appr_occ_lvrabove80
gen ap_occ_midlvr = appr_occ_lvrabove80 - appr_occ_lvrabove90
gen ap_occ_hghlvr = appr_occ_lvrabove90
foreach x of varlist ap_inv_lowlvr-ap_occ_hghlvr {
   gen gr_`x' = 100*(`x'[_n] - `x'[_n-1])
}

****************************************************
******** Defining RHS variables 
****************************************************

*** Define macropru variable 

*** zero except for the quarter when MacP announcement made
***December 2014 = qtr 219, MarQ-15 = qtr 220, September 2015 = 222, March 2017 = qtr 228, Switching off - June 2018 = qtr 233, Dec 2018 = qtr 235
gen MacP = qtr == 219 | qtr == 228
***separate into two MacP instances
gen MacP1 = qtr == 219
gen MacP2 = qtr == 228



**************
*Generate the Major bank, non-major bank dummy variable and MacP interaction terms
**************
gen MajorBank = bank == "ANZ" | bank == "CBA" | bank == "NAB" | bank == "WBC"
gen MBMP1 = MajorBank*MacP1
gen MBMP2 = MajorBank*MacP2
*non-major dummy
gen NMB = MajorBank == 0 
gen NMBMP1 = NMB*MacP1
gen NMBMP2 = NMB*MacP2

*** defining bank controls
gen size = log(assets)
gen capitalratio = (tier1cap/totalrwa)
gen funding = (deposits/liabilities)
gen liquidity = (rbabalance/totalrwa)
*and macro controls
gen houseprice = housepr_qpd 
gen dcashrate = cr_qe - cr_qe[_n-1]
gen GDP = gdp_qpd
* and lags of some of them
foreach x in size capitalratio funding liquidity houseprice {
	gen l`x' = `x'[_n-1]
}


*** Set quarterly dummies for seasonal adjustment.
gen qtr_str = substr(period, 6, 2)
encode qtr_str, gen(qtr_fac)
tab qtr_fac, gen(qtr_dum)
*** Allow seasonality for majors to differ
foreach x in qtr_dum1 qtr_dum2 qtr_dum3 qtr_dum4 {
	gen MB_`x' = MajorBank * `x'
	gen NMB_`x' = NMB * `x'
}
*** Create dummy for cash rate reductions in case this allows banks to raise the spread
gen cr_reduc = dcashrate < 0

****************************************************
******** Treatment intensity variables 
****************************************************
*Intensity treatment with a below and above dummy using dummy variable strategy not interest rate data

*define investor credit growth
gen InvCredGrth = (outs_inv_closbal/outs_inv_closbal[_n-4])*100 - 100
*summarize InvCredGrth, detail
*hist InvCredGrth if MajorBank==1

*define treatment intensity variable
gen InvCredGrthGap = InvCredGrth - 10.00
*Take first lag
gen InvCredGrthGap_1 = InvCredGrthGap[_n-1]
*Take second lag
gen InvCredGrthGap_2 = InvCredGrthGap[_n-2]
* Scale to decimals
replace InvCredGrthGap_2 = (InvCredGrthGap[_n-2])/100

*Lag the policy dummy to interact with the treatment intensity
foreach lag in 1 2 3 4 {
	gen MacP1_`lag' = MacP1[_n-`lag']
	gen MacP1_intens_`lag' = MacP1_`lag' * InvCredGrthGap_2
	gen MacP1_altintens_`lag' = MacP1_`lag' * InvCredGrthGap_1
	gen MacP1_dum_abv_`lag' = 1 if !missing(InvCredGrthGap_2) & !missing(MacP1_`lag')
	replace MacP1_dum_abv_`lag' = 0 if MacP1_intens_`lag' <= 0
}

*Treatment intensity for IO policy
gen IOShare = (appr_tot_io/appr_tot_tot)*100	
gen IOgap = IOShare - 30
gen IOgap_2 = IOgap[_n-2] 
* Scale to decimals
replace IOgap_2 = (IOgap[_n-2])/100

foreach lag in 0 1 2 3 4 {
	gen MacP2_`lag' = MacP2[_n-`lag']
	gen MacP2_intens_`lag' = MacP2_`lag' * IOgap_2
	gen MacP2_dum_abv_`lag' = 1 if !missing(IOgap_2) & !missing(MacP2_`lag')
	replace MacP2_dum_abv_`lag' = 0 if MacP2_`lag' * IOgap_2 <= 0
}
*Treatment intesnities with major/nonmajor split
foreach lag in 1 2 3 4 {
	gen MB_MacP1_intens_`lag' = MajorBank * MacP1_intens_`lag'
	gen MB_MacP1_dum_abv_`lag' = MajorBank * MacP1_dum_abv_`lag'
	gen MB_MacP2_intens_`lag' = MajorBank * MacP2_intens_`lag'
	gen MB_MacP2_dum_abv_`lag' = MajorBank * MacP2_dum_abv_`lag'
}

****************************************************
******** Spread interaction variables 
****************************************************
* First rename
gen spr_inv = d_spread_invpi
gen spr_oo = d_spread_oopi
gen spr_inv_l1 = spr_inv[_n-1]
gen spr_oo_l1 = spr_oo[_n-1]

foreach lag in 1 2 3 4 {
	gen spr_inv_MP1_l`lag' = spr_inv * MacP1_`lag'
	gen spr_inv_l1_MP1_l`lag' = spr_inv_l1 * MacP1_`lag'
	gen spr_inv_MP2_l`lag' = spr_inv * MacP2_`lag'
	gen spr_inv_l1_MP2_l`lag' = spr_inv_l1 * MacP2_`lag'
	gen spr_oo_MP1_l`lag' = spr_oo * MacP1_`lag'
	gen spr_oo_l1_MP1_l`lag' = spr_oo_l1 * MacP1_`lag'
	gen spr_oo_MP2_l`lag' = spr_oo * MacP2_`lag'
	gen spr_oo_l1_MP2_l`lag' = spr_oo_l1 * MacP2_`lag'
}
foreach x of varlist spr_inv-spr_oo_l1_MP2_l4 {
	gen MB_`x' = `x' * MajorBank
}
gen MB_dl_inv_l1 = dl_inv[_n-1] * MajorBank
gen MB_dl_inv_l2 = dl_inv[_n-2] * MajorBank
gen MB_dl_OO_l1 = dl_OO[_n-1] * MajorBank
gen MB_dl_OO_l2 = dl_OO[_n-2] * MajorBank

****************************************************
******** Aggregates
****************************************************


****************************************************
******** Sample selection variables
****************************************************
************** This code generates dummy variables that systematically identify the subsamples of banks for 
* the four types of regressions (policy 1 vs 2 and 'qnt' vs 'int'). It drops banks that had missing DV values 
* four quarters before the policy announcement (which for policy 1 is qtr 215; for policy 2 is qtr 224). 

*List the banks kept for policy 1 for quantity regressions
*list bank if qtr == 215 & dl_inv != . & dl_OO != . & dl_loans != .
*Generate identifier for quantity regressions
gen policy1_qnt_banks = 1 if qtr == 215 & dl_inv != . & dl_OO != . & dl_loans != .
bysort bank (policy1_qnt_banks): replace policy1_qnt_banks = policy1_qnt_banks[1]
replace policy1_qnt_banks = 0 if missing(policy1_qnt_banks)
*And for interest rate regressions
*list bank if qtr == 215 & spread_invpi != . & spread_oopi != .
gen policy1_int_banks = 1 if qtr == 215 & spread_invpi != . & spread_oopi != .
bysort bank (policy1_int_banks): replace policy1_int_banks = policy1_int_banks[1]
replace policy1_int_banks = 0 if missing(policy1_int_banks)

*List the banks kept for policy 2 for quantity regressions
*list bank if qtr == 224 & dl_TotalIO != . & dl_TotalPI != . & dl_loans != .
*Generate identifier for quantity regressions
gen policy2_qnt_banks = 1 if qtr == 224 & dl_TotalIO != . & dl_TotalPI != . & dl_loans != .
bysort bank (policy2_qnt_banks): replace policy2_qnt_banks = policy2_qnt_banks[1]
replace policy2_qnt_banks = 0 if missing(policy2_qnt_banks)
*And for interest rate regressions
*list bank if qtr == 224 & spread_invio_rep != . & spread_invpi != .
gen policy2_int_banks = 1 if qtr == 224 & spread_invio_rep != . & spread_invpi != .
bysort bank (policy2_int_banks): replace policy2_int_banks = policy2_int_banks[1]
replace policy2_int_banks = 0 if missing(policy2_int_banks)
*List all banks used in paper (has duplicates)
*list bank if (qtr == 215 & dl_inv != . & dl_OO != . & dl_loans != .) | (qtr == 215 & spread_invpi != . & spread_oopi != .) | (qtr == 224 & dl_TotalIO != . & dl_TotalPI != . & dl_loans != .) | (qtr == 224 & spread_invio_rep != . & spread_invpi != .)
*drop policy1_qnt_banks policy1_int_banks policy2_qnt_banks policy2_int_banks
xtset institution qtr 


